<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m1="http://www.sec.gov/edgar/sdrfiler"
	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/statecodes" xmlns:ns3="http://www.sec.gov/edgar/sdrcommon">

	<!-- Item 2 templates -->
	<xsl:template name="Item2">
		<h3>
			<em>General Information (1-7)
			</em>
		</h3>
		<xsl:call-template name="generalInfo1" />
	</xsl:template>

	<xsl:template name="generalInfo1">
		<table role="presentation" >
			<tr>
				<h4>
					<em>1. Name under which business is conducted, if
						different than
						name specified herein:</em>
				</h4>
			</tr>
			<tr>
				<td class="label">Name under which business is conducted, if
					different
					than
					name specified herein:
				</td>
				<td>
					<p>
						<div class="fakeBox3">
							<xsl:value-of
								select="string(m1:generalInfo/m1:business/m1:businessName/m1:nameOnBusiness)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">
					Request Confidentiality:
				</td>
				<td>
					<xsl:choose>
						<xsl:when
							test="string(m1:generalInfo/m1:business/m1:businessName/m1:nameOnBusinessConfFlag) = 'true'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />

						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>

		<table role="presentation" >
			<tr>
				<h4>
					<em>2. If name of business is amended, state previous
						business name:</em>
				</h4>
			</tr>
			<tr>
				<td class="label">If name of business is amended, state previous
					business
					name:
				</td>
				<td>
					<p>
						<div class="fakeBox3">
							<xsl:value-of
								select="string(m1:generalInfo/m1:business/m1:previousBusinessName/m1:previousBusinessName)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">
					Request Confidentiality:
				</td>
				<td>
					<xsl:choose>
						<xsl:when
							test="string(m1:generalInfo/m1:business/m1:previousBusinessName/m1:previousBusinessNameConfFlag) = 'true'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />

						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>

		<table role="presentation" >
			<tr>
				<h4>
					<em>3. Mailing address:</em>
				</h4>
			</tr>
			<tr>
				<td class="label">Address 1 </td>
				<td>
					<p>
						<div class="fakeBox">
							<xsl:value-of
								select="string(m1:generalInfo/m1:business/m1:businessAddress/m1:street1)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">Address 2 </td>
				<td>
					<p>
						<div class="fakeBox">
							<xsl:value-of
								select="string(m1:generalInfo/m1:business/m1:businessAddress/m1:street2)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">City </td>
				<td>
					<p>
						<div class="fakeBox">
							<xsl:value-of
								select="string(m1:generalInfo/m1:business/m1:businessAddress/m1:city)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">State/Country   </td>
				<td>
					<p>
						<div class="fakeBox">
							<xsl:call-template name="stateDescription">
								<xsl:with-param name="stateCode"
									select="string(./m1:generalInfo/m1:business/m1:businessAddress/m1:stateOrCountry)" />
							</xsl:call-template>
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">Mailing Zip/ Postal Code  </td>
				<td>
					<p>
						<div align="left">
							<div class="fakeBox2">
								<xsl:value-of
									select="string(m1:generalInfo/m1:business/m1:businessAddress/m1:zipCode)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">
					Request Confidentiality:
				</td>
				<td>
					<xsl:choose>
						<xsl:when
							test="string(m1:generalInfo/m1:business/m1:businessAddress/m1:businessAddressConfFlag) = 'true'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />

						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>

		<table role="presentation" >
			<tr>
				<h4>
					<em>4. List of principal office(s) and address(es) where
						security-based swap data repository
						and securities information
						processor activities are conducted:
					</em>
				</h4>
			</tr>
		</table>
		<!-- repeatable -->
		<xsl:for-each select="m1:generalInfo/m1:officeInfo/m1:office">
			<table role="presentation" >
				<tr>
					<td class="label">Office
					</td>
					<td>
						<p>
							<div class="fakeBox3">
								<xsl:value-of select="m1:officeName" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">Address 1 </td>
					<td>
						<p>
							<div class="fakeBox">
								<xsl:value-of select="m1:street1" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">Address 2 </td>
					<td>
						<p>
							<div class="fakeBox">
								<xsl:value-of select="m1:street2" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">City </td>
					<td>
						<p>
							<div class="fakeBox">
								<xsl:value-of select="m1:city" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">State/Country   </td>
					<td>
						<p>
							<div class="fakeBox">
								<xsl:call-template name="stateDescription">
									<xsl:with-param name="stateCode" select="./m1:stateOrCountry" />
								</xsl:call-template>
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">Mailing Zip/ Postal Code  </td>
					<td>
						<p>
							<div align="left">
								<div class="fakeBox2">
									<xsl:value-of select="m1:zipCode" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</div>
						</p>
					</td>
				</tr>
			</table>
		</xsl:for-each>

		<table role="presentation" >
			<tr>
				<td class="label">
					Request Confidentiality:
				</td>
				<td>
					<xsl:choose>
						<xsl:when
							test="string(m1:generalInfo/m1:officeInfo/m1:officeConfFlag) = 'true'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />

						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>

		<table role="presentation" >
			<tr>
				<h4>
					<em>5. If the applicant is a successor (within the definition of
						Rule 12b-2 under the Exchange Act)
						to a previously registered
						security-based swap data repository,
						please complete the following:</em>
				</h4>
			</tr>
			<tr>
				<td class="label">
					Not Applicable:
				</td>
				<td>
					<xsl:choose>
						<xsl:when
							test="string(m1:generalInfo/m1:successor/m1:successionFlag) = 'true'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<xsl:if
				test="string(m1:generalInfo/m1:successor/m1:successionFlag) = 'false'">

				<xsl:if
					test="string(m1:generalInfo/m1:successor/m1:successionDateFlag) = 'false'">
					<tr>
						<td class="label">a. Date of Succession:
						</td>
						<td>
							<p>
								<div class="fakeBox">
									<xsl:value-of
										select="string(m1:generalInfo/m1:successor/m1:successionDate)" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</p>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="label">
						Not Applicable(a):
					</td>
					<td>
						<xsl:choose>
							<xsl:when
								test="string(m1:generalInfo/m1:successor/m1:successionDateFlag) = 'true'">
								<img src="Images/box-checked.jpg" alt="Checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>

				<xsl:if
					test="string(m1:generalInfo/m1:successor/m1:predecessorNameAddressFlag) = 'false'">
					<tr>
						<td class="label">b. Full name and address of predecessor
							security-based
							swap data repository:
						</td>
						</tr>
						<tr>
						<td class="label">Name</td>
						<td>
							<p>
								<div class="fakeBox">
									<xsl:value-of
										select="string(m1:generalInfo/m1:successor/m1:predecessorName)" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</p>
						</td>
					</tr>
					<tr>
						<td class="label">Address 1 </td>
						<td>
							<p>
								<div class="fakeBox">
									<xsl:value-of select="string(m1:generalInfo/m1:successor/m1:street1)" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</p>
						</td>
					</tr>
					<tr>
						<td class="label">Address 2 </td>
						<td>
							<p>
								<div class="fakeBox">
									<xsl:value-of select="string(m1:generalInfo/m1:successor/m1:street2)" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</p>
						</td>
					</tr>
					<tr>
						<td class="label">City </td>
						<td>
							<p>
								<div class="fakeBox">
									<xsl:value-of select="string(m1:generalInfo/m1:successor/m1:city)" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</p>
						</td>
					</tr>
					<tr>
						<td class="label">State/Country   </td>
						<td>
							<p>
								<div class="fakeBox">
									<xsl:call-template name="stateDescription">
										<xsl:with-param name="stateCode"
											select="string(./m1:generalInfo/m1:successor/m1:stateOrCountry)" />
									</xsl:call-template>
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</p>
						</td>
					</tr>
					<tr>
						<td class="label">Mailing Zip/ Postal Code  </td>
						<td>
							<p>
								<div align="left">
									<div class="fakeBox2">
										<xsl:value-of select="string(m1:generalInfo/m1:successor/m1:zipCode)" />
										<span>
											<xsl:text>&#160;</xsl:text>
										</span>
									</div>
								</div>
							</p>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="label">
						Not Applicable(b):
					</td>
					<td>
						<xsl:choose>
							<xsl:when
								test="string(m1:generalInfo/m1:successor/m1:predecessorNameAddressFlag) = 'true'">
								<img src="Images/box-checked.jpg" alt="Checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>

				<xsl:if
					test="string(m1:generalInfo/m1:successor/m1:predecessorCikFlag) = 'false'">
					<tr>
						<td class="label">c. Predecessor's CIK: </td>
						<td>
							<p>
								<div align="left">
									<div class="fakeBox2">
										<xsl:value-of select="string(m1:generalInfo/m1:successor/m1:cik)" />
										<span>
											<xsl:text>&#160;</xsl:text>
										</span>
									</div>
								</div>
							</p>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="label">
						Not Applicable(c):
					</td>
					<td>
						<xsl:choose>
							<xsl:when
								test="string(m1:generalInfo/m1:successor/m1:predecessorCikFlag) = 'true'">
								<img src="Images/box-checked.jpg" alt="Checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					Request Confidentiality:
				</td>
				<td>
					<xsl:choose>
						<xsl:when
							test="string(m1:generalInfo/m1:successor/m1:successorConfFlag) = 'true'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />

						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>

		<table role="presentation" >
			<tr>
				<h4>
					<em>6. List all asset classes of security-based swaps for which the
						applicant is collecting and maintaining
						data or for which it
						proposes to collect and maintain data.</em>
				</h4>
			</tr>
			<tr>
				<td>
				</td>
				<td>
					<p>
						<div class="fakeBox3">
							<xsl:value-of
								select="string(m1:generalInfo/m1:assetClasses/m1:assetClassesList)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">
					Request Confidentiality:
				</td>
				<td>
					<xsl:choose>
						<xsl:when
							test="string(m1:generalInfo/m1:assetClasses/m1:assetClassesConfFlag) = 'true'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>

		<table role="presentation" >
			<tr>
				<h4>
					<em>7. Furnish a description of the function(s) that the applicant
						performs or proposes to perform.</em>
				</h4>
			</tr>
			<tr>
				<td>
				</td>
				<td>
					<p>
						<div class="fakeBox3">
							<xsl:value-of
								select="string(m1:generalInfo/m1:functionDescription/m1:functionDescriptionPerformed)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">
					Request Confidentiality:
				</td>
				<td>
					<xsl:choose>
						<xsl:when
							test="string(m1:generalInfo/m1:functionDescription/m1:functionDescriptionConfFlag) = 'true'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>